/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.theme.internal;

import com.aptana.theme.IThemeManager;
import com.aptana.theme.ThemePlugin;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import org.eclipse.jface.action.ContributionItem;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.ui.menus.IWorkbenchContribution;
import org.eclipse.ui.services.IServiceLocator;

public class SwitchThemesPulldownContributionItem
extends ContributionItem
implements IWorkbenchContribution {
    public SwitchThemesPulldownContributionItem() {
    }

    public SwitchThemesPulldownContributionItem(String id) {
        super(id);
    }

    public void fill(Menu menu, int index) {
        IThemeManager manager = ThemePlugin.getDefault().getThemeManager();
        ArrayList<String> themeNames = new ArrayList<String>(manager.getThemeNames());
        Collections.sort(themeNames, new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                return o1.compareToIgnoreCase(o2);
            }
        });
        for (String name : themeNames) {
            SwitchThemeContributionItem item = new SwitchThemeContributionItem(manager, name);
            item.fill(menu, menu.getItemCount());
        }
    }

    public void initialize(IServiceLocator serviceLocator) {
    }

    private static void switchTheme(IThemeManager manager, String themeName) {
        manager.setCurrentTheme(manager.getTheme(themeName));
    }

    private class SwitchThemeContributionItem
    extends ContributionItem {
        private IThemeManager manager;
        private String branchName;

        SwitchThemeContributionItem(IThemeManager repo, String themeName) {
            this.manager = repo;
            this.branchName = themeName;
        }

        public void fill(Menu menu, int index) {
            MenuItem menuItem = new MenuItem(menu, 8, index);
            menuItem.setText(this.branchName);
            menuItem.setEnabled(!this.branchName.equals(this.manager.getCurrentTheme().getName()));
            menuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    SwitchThemesPulldownContributionItem.switchTheme(SwitchThemeContributionItem.this.manager, SwitchThemeContributionItem.this.branchName);
                }
            });
        }
    }
}

